\version "2.18.0"
\language "deutsch"

\paper {
  %system-system-spacing = #'((basic-distance . 16))
  markup-system-spacing = #'((basic-distance . 23))
  left-margin = 1.5\cm
  line-width = 19.4\cm
  print-page-number = false
  top-margin = 10\mm
  bottom-margin = 5\mm
  ragged-last-bottom=##f
  %system-count = #6
}

% diacritice: ă â î ş ţ Ţ Ş Ă Î

\header {
  title = "Iubi-Te-voi, Doamne"
  subtitle = "glasul 5"
  %subsubtitle = "(variantă)"
  %poet = "Sigmund von Birken 1663"
  composer = "după Evghenie Humulescu"
  arranger =  "N. Lungu / N. Moldoveanu"
  %meter = "Andante"
  tagline = ""
}

global = {
  %#(set-global-staff-size 19)
  \key b \major
  %\key d \minor
  \cadenzaOff
  \time 4/4
  \partial 4
  %\override Staff.TimeSignature #'stencil = ##f
  \set Staff.midiInstrument = "clarinet"
  \autoBeamOff
  
}


soloWords = \lyrics {
  Iu -- bi -- Te -- voi Doam -- ne,
  vâr -- tu -- tea __ mea. __
  Dom -- nul es -- te
  în -- tă -- ri -- rea __ mea __
  şi scă -- pa -- rea mea
  şi iz -- bă -- vi -- to -- rul meu.
}  

womenWords = \lyrics {
  Iu -- bi -- Te -- voi Doam -- ne, __
  iu -- bi -- Te -- voi Doam -- ne,
  vâr -- tu -- tea mea, vâr -- tu -- tea mea.
  Dom -- nul e în -- tă -- ri -- rea __ mea __
  şi scă -- pa -- rea mea şi scă -- pa -- rea mea
  şi iz -- bă -- vi -- to -- rul meu,
  iz -- bă -- vi -- to -- rul meu.
}  

menWords = \lyrics {
  Iu -- bi -- Te -- voi Doam -- ne, __
  iu -- bi -- Te -- voi Doam -- ne,
  vâr -- tu -- tea mea.
  Dom -- nul e în -- tă -- ri -- rea __ mea __
  şi scă -- pa -- rea, scă -- pa -- rea mea
  şi iz -- bă -- vi -- to -- rul meu,
  iz -- bă -- vi -- to -- rul meu.
}  

soloMusic = \relative c'' {
  r4 r1 r r2 r4 g4^\mp
  d'2 c4 d f8^\accent ([ es d c]) b4 a8([ b])
  c8.([ d16 c8 d]) b([ a] g4) f'8( es4 d16[ c] d2) ~ d4 r
  f4 f8([ g]) f([ e]) d4 e f8([ e16 f]) g4( a8[ g]) f4( es8.[ d16]) d2( d8) r r4
  \time 2/4 d4 d
  \time 4/4 a'8( g4 a8) f8([ es d es]) c2( c4) r
  g8([ c b c]) d([ es f g])
  d4( c8[ b]) \times 2/3 { c8([ b a] } b[ c])
  c8([ b16 c] b8[ a]) g8([ a16 b] g4) 
  g1( g g2.) r4
  %d16([ e d8] c4. d8 e[ f] e4 d2.)
  \bar "|."
}

sopMusic = \relative c'' {
  g4^\p
  d'2 c4 d es2( d4 c) d1( d2.) \breathe 
  d4 d2 d4 d es2 d4 d c c d4. 
  es8 f4 es d2 d4 d d d8 d d2 d d 
  d4 d d d d2( c4) b4\rest c d8([ es]) f4 f es2 
  d4 d d2 es es4( d) d2 d4 b8\rest 
  d^\pp d4 d es2. es4 d2.^\ppp b4\rest
  
}

altMusic = \relative c'' {
  g4 b2 a4 b c2( b4 a) b1( b2.) b4
  b2 b4 b c2 b4 b a a b4. c8
  d4 c b2 a4 a a a8 a b4( a8[ b]) a4( g) a2 d4 c
  b4 b b2( a4) b4\rest c4 c c c c2 b4 b
  b2 c c4( b) b2 b4 b8\rest b b4 b c2. c4 b2. b4\rest
}

tenorMusic = \relative c' {
  g4 g2 g4 g g2( d) g1( g2.) g4
  g2 g4 g g2 g4 g f f f4. d8\rest
  d1\rest d4 d d d8 d d2 d d d\rest
  b'4 b g2 a4 \breathe b4 a2. a4 g2 g4 g
  g2 g g g g4 d8\rest g g4 g g2. g4 g2. d4\rest
}

bassMusic = \relative c {
  g4 g2 g4 g g2( d') g,1( g2.) g4
  g2 g4 g c2 d4 es f f b,4. d8\rest
  d1\rest d4 d d d8 d d2 d d d\rest
  b'4 b g2 a4 \breathe b4 f2. f4 c2 g4 g
  g2 c c4( d) g,2 g4 d'8\rest g, g4 g c2. c4 g2. d'4\rest

}

myScore = \new Score <<
  \new Staff <<
      \set Staff.instrumentName = "Solo Tenor"    
      \new Voice { \global \soloMusic }
      \addlyrics { \soloWords }
      
    >>
  \new ChoirStaff <<
    \new Staff <<
      \new Voice { \voiceOne \global \sopMusic }
      \new Voice { \voiceTwo \global \altMusic }
      \addlyrics { \womenWords }
      
    >>
    \new Staff <<
      \clef bass
      \new Voice { \voiceOne \global \tenorMusic }
      \new Voice { \voiceTwo \global \bassMusic }
      \addlyrics { \menWords }
    >>
    >>
>>

\score {
  \myScore
  \layout { }
}

midiOutput = \midi {
    \tempo 4 = 30
    \context { \Voice \remove "Dynamic_performer" }
}

\score {
  \myScore
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \soloMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \tenorMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}