\version "2.18.0"
\language "deutsch"

\paper {
  system-system-spacing = #'((basic-distance . 16))
  markup-system-spacing = #'((basic-distance . 14))
  left-margin = 1.5\cm
  line-width = 19.4\cm
  print-page-number = false
  top-margin = 10\mm
  bottom-margin = 5\mm
  %ragged-last-bottom=##f
  system-count = #3
}

% diacritice: ă â î ş ţ Ţ Ş Ă

\header {
  title = "Veniţi să ne închinăm"
  subtitle = "glasul 1"
  composer = "arm. după N. Lungu"
  %meter = "Moderato"
  tagline=""
}

global = {
  %#(set-global-staff-size 19)
  \key f \major
  \time 2/4
  \partial 4
  \set Staff.midiInstrument = "clarinet"
  \autoBeamOn
}

womenWords = \lyricmode {
  Ve -- niţi să ne în -- chi -- năm şi să că -- dem la Hris -- tos.
  Mân -- tu -- ieş -- te -- ne pe noi, Fi -- ul lui Dum -- ne -- zeu,
  Cel ce ai în -- vi -- at din __ morţi,
  pe noi cei ce-ţi cân -- tăm: A -- li -- lu -- i -- a. __
}

menWords = \lyricmode {
  \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1
  \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1
  \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1
  \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1
  \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1
  \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1
  
  
  A -- li -- lu -- i -- a.
}

sopMusic = \relative c'' {
  a4^\mf 
  d( c) b a g f g4. a8 g4 f f( e) d cis d2
  d4 d g g f g a2 c4( b) a g f g a2 
  b4( a) g g a b c2 b4( a) g4. 
  d8 g4 g f g a2 f4 f g g d2( d d)^\fermata
  \bar "|."
}

altMusic = \relative c'' {
  a4 d( c) b a g f g4. a8 g4 f f( e) d cis d2
  d4 d g g f e f2 a4( g) f e d e f2
  g4( f) e e f g a2 g4( f) e4.
  d8 g4 g f e f2 d4 d g g d2( d d)
}

tenorMusic = \relative c' {
  a4 d( c) b a g d g4. a8 g4 f f( e) d cis d2
  d4 d g g f c f2 f4( g) f c d c f2
  e4( f) c c f e f2 e4( f) c4.
  d8 d4 d d c f2 r2 r d4 d g g d2

}

myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff <<
     \new Voice { \voiceOne \global \sopMusic }
      \addlyrics { \womenWords }
      \new Voice { \voiceTwo \global \altMusic }
      >>
    
    \new Staff <<
      \clef bass
      \new Voice { \global \tenorMusic }
      %\new Voice { \voiceOne \global \tenorMusic }
      %\new Voice { \voiceTwo \global \bassMusic }
      %\new Voice { \global \bassMusic }
      \addlyrics { \menWords }
      >>
    
  >>
>>

\score {
  \myScore
  \layout { }
}

midiOutput = \midi {
   \tempo 4 = 60
   \context { \Voice \remove "Dynamic_performer" }
}

\score {
  %\unfoldRepeats
  \myScore
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \tenorMusic }
  \midi { \midiOutput }
}