\version "2.16.0"
\language "deutsch"

\paper {
  markup-system-spacing = #'((basic-distance . 2))
  left-margin = 1.5\cm
  line-width = 19.4\cm
  print-page-number = false
  top-margin = 10\mm
  bottom-margin = 5\mm
  ragged-last-bottom=##f
  system-count = #10
}

% diacritice: ă â î ş ţ Ţ Ş Ă Î

\header {
  title = "Antifonul al II-lea"
  subtitle = "Imnul lui Iustinian"
  subsubtitle = "Mărire... şi acum... Unule Născut"
  composer = "arm. după N. Lungu"
  %meter = "Allegretto"
  tagline=""
}

global = {
  \key f \major
  \autoBeamOff
  %\cadenzaOn
  %\numericTimeSignature\time 4/4 
  %\partial 2
  \set Staff.midiInstrument = "clarinet"
}

womenWords = \lyricmode {
  A -- min.
  Mă -- ri -- re Ta -- tă -- lui şi Fi -- u -- lui şi Sfân -- tu -- lui Duh.
  U -- nu -- le Năs -- cut, Fi -- u -- le şi Cu -- vân -- tul lui Dum -- ne -- zeu,
  Ce -- la ce eşti fă -- ră de moar -- te 
  şi ai pri -- mit, pen -- tru mân -- tu -- i -- rea noas -- tră, 
  a Te în -- tru -- pa din Sfân -- ta Năs -- că -- toa -- re de Dum -- ne -- zeu
  şi pu -- ru -- rea Fe -- cioa -- ră Ma -- ri -- a; 
  Ca -- re ne -- schim -- bat Te-ai în -- tru -- pat 
  şi răs -- tig -- nin -- du -- Te, Hris -- toa -- se Dum -- ne -- ze -- u -- le, 
  cu moar -- tea pe moar -- te ai căl -- cat. 
  U -- nul fi -- ind din Sfân -- ta Tre -- i -- me, 
  îm -- pre -- u -- nă mă -- rit cu Ta -- tăl şi cu Du -- hul Sfânt, 
  mân -- tu -- ieş -- te -- ne pe noi.
}


menWords = \lyricmode {
  %\skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1
  %\skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1
  \skip 1 \skip 1 
  Şi a -- cum şi pu -- ru -- rea şi în ve -- cii ve -- ci -- lor, A -- min.
  \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1
  \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1
  \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1
  \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1
  %şi toa -- te ce -- le
 
}
  
sopMusic = \relative c'' {
  f,2^\mf a2 \fermata \bar "||"
  \time 2/4
  \partial 4 a4
  d4 a4 | % 4
  b4 g4 a4. \breathe a8 | % 5
  a4 g4 f4 b4 | % 6
  a4 ( g4 ) f4 e4 | % 7
  d2 \breathe 
  %d4 cis4 | % 8
  %d4 e4 f8 ( [ g8 ]) f8 ([ e8 ]) | % 9
  %f2 \breathe f4 g4 | 
  %a4 g4 | % 11
  %a4 g4 f4 e4 | % 12
  %d2 
  h'2\rest  h2\rest  h2\rest  h2\rest
  h2\rest  h2\rest  h2\rest  h2\rest h2\rest
  \bar "||"
  f4 e4 d4 cis4 d2 g8 ([ f]) e4 f2 f4 g a( g)
  f4 e f g a2 b8([ c] b4) a4 g a g f8([ e]) d4
  e4( f) d2 a'4( g) f g a2 a4 g a h c h
  c4( d) a4.( b8) a4 g f e d4. e8 f4 e f g
  a4( g) f e f g a4. a8 b4 b a g a( g)
  f8([ e]) d4 e( f) d2 f4( e) d( cis) d e f e8([ d])
  cis4 b a4. a'8 a4 a d d a a b a g a
  b4 g a4. g8 g2 fis4 g a g fis es d2
  a'4( g) f g a a b( a) b cis d2 a
  a4 a d8([ e] d4) c h a h c h c^\< d
  e4 c d2^\f\fermata\!
  a4^\p^\markup"rall..." b a g f2 e d \fermata  
  \bar "|."
}

altMusic = \relative c' {
  f2 a
  a4 f f g e f4. f8 f4 e d g f( e) d cis d2
  %d4 cis d e d d d2 d4 e f e f e d cis d2
  h'2\rest  h2\rest  h2\rest  h2\rest
  h2\rest  h2\rest  h2\rest  h2\rest h2\rest
  f4 e4 d4 cis4 d2 g8 ([ f]) e4 d2 d4 e f( e)
  d4 e d e f2 g2 f4 e f g f8([ e]) d4
  cis2 d f4( e) d e f2 f4 e f g a h
  a4( b) a4. r8 f4 e d cis d4. cis8 d4 cis d e
  f4( e) d e d e f4. f8 g4 g f e f( g)
  f8([ e]) d4 cis2 d2 f4( e) d( cis) d e f e8([ d])
  cis4 b a4. a'8 a4 a f f f f g f e f
  g4 e f4. g8 g2 d4 g a g fis es d2
  f4( e) d e f f g( f) g a f2 f
  a4 a f2 e4 e a a a a a a
  a4 a8([ g]) f2 f4 g f e d2 cis d
}

tenorMusic =  \relative c {
  f2 f
  %d4 d d g g d4. d8 d4 cis d g f( e) d a d2  
  d4\rest d2\rest d2\rest d2\rest d2\rest
  d2\rest d2\rest d2\rest d2\rest
  %d4 cis d e d d d2 d4 c f e f e d a d2
  d4 cis4 d4 e4 f8 ( [ g8 ]) f8 ([ e8 ]) 
  f2 \breathe f4 g4 a4 g4 a4 g4 f4 e4 d2 
  f4 e4 d4 cis4 d2 g8 ([ f]) e4 d2 d4 c f( e)
  d4 e d c f2 g d4 e f g f8([ e]) d4
  a2 d f4( e) d c f2 f4 e f g a h
  a4( b) a4. d,8\rest a4 a a a d4. a8 d4 cis d e
  f4( e) d e d c f4. f8 g4 g d e f( g)
  f8([ e]) d4 a2 d2 f4( e) d( cis) d e f e8([ d])
  cis4 b a4. a'8 a4 a d, d d d g f e f
  c4 c f4. g8 g2 d4 g a g fis es d2
  f4( e) d c f f g( f) e e d2 d
  a'4 a d,2 e4 e a a a a a a
  a4 a d,2 f4 g f e d2 a d
  
}

bassMusic = \relative c {
  f2 f
  %d4 d d g g d4. d8 d4 cis d g f( e) d a d2  
  d4\rest d2\rest d2\rest d2\rest d2\rest
  d2\rest d2\rest d2\rest d2\rest
  %d4 cis d e d d d2 d4 c f c f e d a d2
  d4 cis d e d d d2 d4 e f e f e d cis d2
  f4 e4 d4 cis4 d2 g8 ([ f]) e4 d2 d4 c f( e)
  d4 e d c f2 g d4 e f g f8([ e]) d4
  a2 d f4( e) d c f2 f4 e f g a h
  a4( b) a4. d,8\rest a4 a a a d4. a8 d4 cis d e
  f4( e) d e d c f4. f8 g4 g d e f( g)
  f8([ e]) d4 a2 d2 f4( e) d( cis) d e f e8([ d])
  cis4 b a4. a'8 a4 a d, d d d g f e f
  c4 c f4. g8 g2 d4 g a g fis es d2
  f4( e) d c f f g( f) e a, d2 d
  a'4 a d,2 e4 e a a a a a a
  a4 a d,2 f4 g f e d2 a d  
}

myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff <<
      \new Voice { \voiceOne \global \sopMusic }
      \addlyrics { \womenWords }
      \new Voice { \voiceTwo \global \altMusic }
    >>
    \new Staff <<
      \clef bass
      %\new Voice { \global \tenorMusic }
      \new Voice { \voiceOne \global \tenorMusic }
      \new Voice { \voiceTwo \global \bassMusic }
      %\new Voice { \global \bassMusic }
      \addlyrics { \menWords }
     >>
    >>
>>

\score {
  \myScore
  \layout { }
}

midiOutput = \midi {
  \tempo 4 = 60
  \context { \Voice \remove "Dynamic_performer" }
}

\score {
  \unfoldRepeats
  \myScore
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \tenorMusic }
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}
