\version "2.16.0"

\paper {
  between-system-padding = 0\mm
  markup-system-spacing = #'((basic-distance . 1))
  left-margin = 1.5\cm
  line-width = 19.4\cm
  print-page-number = false
  top-margin = 4\mm
  ragged-last-bottom=##f
  system-count = #6
}

% diacritice: ă â î ş ţ Ţ Ş Ă Î

\header {
  title = "Axionul Născătoarei de Dumnezeu"
  subtitle = "Cuvine-se cu adevărat"
  composer = \markup \center-column { "Gavriil Musicescu" \small 
  "(1847–1903)" }
  meter = "Moderato"
  tagline=""
}

global = {
  %#(set-global-staff-size 19)
  \key f \major
  \time 4/4
  \partial 4
  \set Staff.midiInstrument = "clarinet"
  \autoBeamOff
}

womenWords = \lyricmode {
  Cu -- vi -- ne- -- se cu a -- de -- vă -- rat
  să te fe -- ri -- cim Năs -- că -- toa -- re de Dum -- ne -- zeu,
  Cea pu -- ru -- rea fe -- ri -- ci -- tă
  şi prea ne -- vi -- no -- va -- tă
  şi Mai -- ca Dum -- ne -- ze -- u -- lui nos -- tru.
  Ce -- ea ce eşti mai cin -- sti -- tă de -- cât he -- ru -- vi -- mii
  şi mai mă -- ri -- tă fă -- ră de a -- se -- mă -- na -- re
  de -- cât se -- ra -- fi -- mii;
  ca -- re fă -- ră stri -- că -- ciu -- ne
  pe Dum -- ne -- zeu Cu -- vân -- tul l-ai năs -- cut,
  pe ti -- ne cea în -- tru a -- de -- văr
  Năs -- că -- toa -- re de Dum -- ne -- zeu __
  te mă -- rim.
}

tenorWords = \lyricmode {
  Cu -- vi -- ne- -- se cu a -- de -- vă -- rat
  să te fe -- ri -- cim Năs -- că -- toa -- re de Dum -- ne -- zeu,
  şi Mai -- ca Dum -- ne -- ze -- u -- lui nos -- tru.
  Ce -- ea ce eşti mai cin -- sti -- tă
  şi mai mă -- ri -- tă fă -- ră de a -- se -- mă -- na -- re
  ca -- re fă -- ră stri -- că -- ciu -- ne
  pe Dum -- ne -- zeu Cu -- vân -- tul l-ai năs -- cut,
  pe ti -- ne cea în -- tru a -- de -- văr
  Năs -- că -- toa -- re de Dum -- ne -- zeu __
  te mă -- rim.
}

bassWords = \lyricmode {
  \skip 1 \skip 1 \skip 1 \skip 1  \skip 1 \skip 1 \skip 1 \skip 1
  \skip 1 \skip 1 \skip 1 \skip 1  \skip 1 \skip 1 \skip 1 \skip 1
  toa -- re de Dum -- ne -- zeu,
}

sopMusic = \relative {
  %\cadenzaOn
  %#(set-accidental-style 'forget)

  % Cuvine-se cu adevărat
  f4^\mf bes2^\< a4\! g f8([ e])^\> f4 g8([ f]) g4\!
  \time 2/4
  a2^\pp
  \time 4/4
  
  % să te fericim Născătoare de Dumnezeu
  f4^\p fis g a bes4.^\<( a8)\! g4 g
  c4.( bes8) a4 c d^\> d cis\! \fermata

  % cea pururea fericită
  a4^\p d4 a8 a fis([ g]) a([ bes]) c4.( bes8) bes4 

  % şi prea nevinovată
  g4^\p c4. g8 e([ f]) g([ a]) bes4.( a8) a4 \breathe

  % şi Maica Dumnezeului nostru.
  a4 d2 c
  \time 2/4
  g4 a
  \time 4/4
  c4( bes) a g g( f2 e4) f2. r4

  % Ceea ce eşti mai cinstită decât heruvimii
  e4^\p g c c a b c g e' e d8([ e]) f([ e]) d2 a4.

  % şi mai mărită făr' de-asemănare
  a8^\p a4 a d d e8 e e e f^\> f d d\!

  % decât serafimii;
  b4^\p b b8([ c]) d([ e]) d2 c4. r8
  
  % carea fără stricăciune
  bes4.^\p^\< bes8 c4\! bes a bes c a

  % pe Dumnezeu Cuvântul ai născut,
  d4 d8 d c c d bes a4^\> g a\! r8

  % pe tine cea cu adevărat
  a8^\pp
  \time 2/4
  a4 a
  \time 4/4
  bes4^\< bes8 bes\! c4 c^\> d2\!

  % Născătoare de Dumnezeu
  g,4^\p g c2^\< bes4\! a
  \time 2/4
  g4 a
  \time 4/4
  c4( bes^\> a g)\! 

  % te mărim, te mărim
  g4^\p( f2) e4 f2. r4
  \bar "|."
}

altMusic = \relative {
  f4^\mf bes2 a4 g f8([ e]) f4 g8([ f]) e([ d]) cis2
  d4 d d d d2 e4 e f2 f4. e8 d4. e8 e4
  a4 fis fis8 fis d([ e]) fis([ g]) a4.( g8) g4
  g4 e4. e8 c([ d]) e([ f]) g4.( f8) f4
  f4 f2 f f4 f g2 d4 d c2( bes) a2. r4
  c4 e e e f d e e g g f8([ g]) a([ g]) f2 f4.
  f8 g4 e a a g8 g g g f f f f
  d4 d d8([ e]) f([ g]) f2 e4. r8
  e4. f8 g4 e f f f f
  f4 f8 f f f f g f4 e f r8
  f8 f4 f f f8 f f4 f f2 
  e4 e f2 e4 f f f g2( d)
  c2 bes a2. r4	
}

tenorMusic = \relative {
  f,4 bes2 a4 g f8([ e]) f4 d g e2
  a4 a g fis g2 g4 c c1 f,8 fis g gis a4
  r4 r1 r r r2 r4
  c4 bes2 a d4 d d2 c4 bes a2( g) f2. r4
  g4 g g g c aes g g r1 r2 r4 r8
  a8 cis4 cis d a a8 a a a a a a a
  r1 r
  c4. c8 c4 c c c c c
  bes4 bes8 bes c f d d c4 c c r8
  c8 c4 c bes4 bes8 bes a4 a bes2
  c4 c c2 c4 c d d d2( c4 bes)
  a2 g f2. r4
  
}

bassMusic = \relative {
  f,4 bes2 a4 g f8([ e]) d8([ c]) bes4 bes a2 
  d4 c bes a g2 c4 bes a4.( g8) f4 a bes bes a
  r4 r1 r r r2 r4
  f'4 bes,2 f' bes,4 a g2 a4 bes c1 f,2. r4
  c'4 c c c c c c c r1 r2 r4 r8
  d8 e4 e f f cis8 cis cis cis d d d d
  r1 r
  g4. f8 e4 c f g a f
  bes4 bes8 bes a a bes g c4 c, f r8
  f8 ees4 ees d4 d8 d c4 c bes2
  bes'4 bes a2 g4 f bes, a g2( a4 bes)
  c2 c f2. r4  
}

myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff <<
      \set Staff.instrumentName = #"S" 
      \new Voice { \global \sopMusic }
      \addlyrics { \womenWords }
    >>
    
    \new Staff <<
      \set Staff.instrumentName = #"A" 
      \new Voice { \global \altMusic }
      %\addlyrics { \womenWords }
    >>
    
    \new Staff <<
      \set Staff.instrumentName = #"T" 
      \clef "G_8"
      \new Voice { \global \tenorMusic }
      \addlyrics { \tenorWords }
    >>

    \new Staff <<
      \set Staff.instrumentName = #"B" 
      \clef bass
      \new Voice { \global \bassMusic }
      \addlyrics { \bassWords }
    >>
  >>
>>

midiOutput = \midi {
    \tempo 4 = 40
    \context { \Voice \remove "Dynamic_performer" }
}

\score {
  \myScore
  \layout { }
}

\score {
  \myScore
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \tenorMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}
