\version "2.18.0"
\language "deutsch"

\paper {
 %#(set-paper-size "a4")
  %markup-system-spacing = #'((basic-distance . 10))
  %system-system-spacing = #'((basic-distance . 10))
  %system-system-spacing #'basic-distance = #1
  left-margin = 1.5\cm
  line-width = 19.4\cm
  print-page-number = false
  top-margin = 10\mm
  bottom-margin = 10\mm
  ragged-last-bottom=##f
  %system-count = #5
}

% diacritice: ă â î ş ţ Ţ Ş Ă Î

\header {
  title = "Aliluia"
  subtitle = "Glas 8 (trifonic)"
  composer =  "arm. N. Moldoveanu"
  meter = "Rar cu umilință"
  tagline=""
}

global = {
  \key b \major
  \cadenzaOn
  \autoBeamOff
  \time 4/4
  %\override Staff.TimeSignature #'stencil = ##f
  %\partial 4
  \set Staff.midiInstrument = "clarinet"
}

womenWords = \lyricmode {
  A -- li -- lu -- i -- a,
  a -- li -- lu -- i -- a,
  a -- li -- lu -- i -- a. 
}

menWords = \lyricmode {
  A -- li -- lu -- i -- a,
  a -- li -- lu -- i -- a,
  a -- li -- lu -- i -- a. 
}

sopMusic = \relative c'' {
  b4.( c8 b4 a) \bar "|"
  \tuplet 3/2 { b8([ a g~] } g4 a8[ b] a4) \bar "|"
  b2( c) \bar "|" \break
  c8([ d] c4 b a) \bar "|"
  b2 \bar "|"
  
  b4.( c8 b4 a) \bar "|"
  \tuplet 3/2 { b8([ a g~] } g4 a8[ b] a4) \bar "|" \break
  b2( c4. d16[ es]) \bar "|"
  d4( c b a) \bar "|"
  b2 \bar "|"
  
  d2( es4 d) \bar "|" \break
  c16([ d c d] c8[ d] b2) \bar "|"
  c4( d es8.[ f16 es8 d]) \bar "|"
  d8.([ es16 d8 c] b[ c] b4) \bar "|"
  b2. b4\rest   
  \bar "|."
}

altMusic = \relative c'' {
  b4.( c8 b4 a) \bar "|"
  \tuplet 3/2 { b8([ a g~] } g4 a8[ b] a4) \bar "|"
  b2( a) \bar "|"
  a8([ b] a4 g a) \bar "|"
  b2 \bar "|"
  
  b4.( c8 b4 a) \bar "|"
  \tuplet 3/2 { b8([ a g~] } g4 a8[ b] a4) \bar "|" \break
  b2( a4. b16[ c]) \bar "|"
  b4( a g a) \bar "|"
  b2 \bar "|"
 
  b1 \bar "|" \break
  a16([ b a b] a8[ b] b2) \bar "|"
  a4( b c8.[ d16 c8 b]) \bar "|"
  b8.([ c16 b8 a] b[ c] b4) \bar "|"
  b2. b4\rest 
}

tenorMusic = \relative c' {
  b4.( c8 b4 a) \bar "|"
  \tuplet 3/2 { b8([ a g~] } g4 f2) \bar "|"
  g( f) \bar "|"
  f( g4 a) \bar "|"
  b2 \bar "|"
  
  b4.( c8 b4 a) \bar "|"
  \tuplet 3/2 { b8([ a g~] } g4 f2) \bar "|"
  g2( f) \bar "|"
  f( g4 f) \bar "|"
  b2 \bar "|"
  
  f2( g4 f) \bar "|" 
  f2( g) \bar "|"
  \skip 1 \bar "|"
  f2( g8[ a] b4) \bar "|"
  b2. d,4\rest  
}

bassMusic = \relative c' {
  b4.( c8 b4 a) \bar "|"
  \tuplet 3/2 { b8([ a g~] } g4 f2) \bar "|"
  g( f) \bar "|" 
  f( g4 a) \bar "|"
  b2 \bar "|"
  
  b4.( c8 b4 a) \bar "|"
  \tuplet 3/2 { b8([ a g~] } g4 f2) \bar "|"
  g2( f) \bar "|"
  b,4( c8[ d] es4 f) \bar "|"
  b2 \bar "|"
  
  b,1 \bar "|"
  f'2( g) \bar "|"
  f1 \bar "|"
  f2( g8[ a] b4) \bar "|"
  b,2. d4\rest  
  
}

myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff <<
      \new Voice { \global \voiceOne \sopMusic }
      \new Voice { \global \voiceTwo \altMusic }
      \addlyrics { \womenWords }
    >>
    \new Staff <<
      \clef bass
      \new Voice { \global \voiceOne \tenorMusic }
      \new Voice { \global \voiceTwo \bassMusic }
      \addlyrics { \menWords }
    >>
    >>
>>

\score {
  \myScore
  \layout { }
}

midiOutput = \midi {
    \tempo 4 = 60
    \context { \Voice \remove "Dynamic_performer" }
}

\score {
  \myScore
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \tenorMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}
